/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.reflection.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.skinsrestorer.api.reflection.access.IAccess;
import net.skinsrestorer.api.reflection.access.MultiImpl;
import net.skinsrestorer.api.reflection.reflect.DuckReflect;

public class DuckBypass {
    private final DuckReflect _reflect;
    private final IAccess _access;
    private boolean _replaced = false;

    public DuckBypass(DuckReflect reflect, IAccess access, boolean replaceSetAccessible) {
        this._reflect = reflect;
        this._access = access;
        if (replaceSetAccessible) {
            this.replaceMethod();
        }
    }

    public DuckBypass(DuckReflect reflect, boolean replaceSetAccessible) {
        this(reflect, new MultiImpl(reflect), replaceSetAccessible);
    }

    public DuckBypass(boolean replaceSetAccessible) {
        this(new DuckReflect(false), replaceSetAccessible);
    }

    public DuckBypass() {
        this(false);
    }

    public void replaceMethod() {
        if (!this._replaced) {
            Method setAccessible = this._reflect.getMethod(AccessibleObject.class, "setAccessible0", false, Boolean.TYPE);
            if (setAccessible != null) {
                if (this._access.setModifiers(setAccessible, 1)) {
                    this._reflect.replaceMethod(setAccessible);
                } else if (this._reflect.setAccessible(setAccessible)) {
                    this._reflect.replaceMethod(setAccessible);
                }
            }
            this._replaced = true;
        }
    }

    public void reset() {
        this._reflect.reset();
    }

    public boolean check() {
        return this._reflect.check();
    }

    public void process(Throwable ex) {
        this._reflect.process(ex);
    }

    public Class<?> getClass(Object obj) {
        return this._reflect.getClass(obj);
    }

    public Class<?> getClass(String name) {
        return this._reflect.getClass(name);
    }

    public Field getField(Class<?> type, String name) {
        return this._reflect.getField(type, name);
    }

    public Object getValue(Field target, Object obj) {
        return this._access.getValue(target, obj);
    }

    public Object getValue(Field target) {
        return this.getValue(target, null);
    }

    public Object getValue(Class<?> type, String name, Object obj) {
        return this.getValue(this.getField(type, name), obj);
    }

    public Object getValue(Class<?> type, String name) {
        return this.getValue(type, name, null);
    }

    public <T> T getValue(Field target, Object obj, Class<T> valType) {
        try {
            return valType.cast(this.getValue(target, obj));
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public <T> T getValue(Field target, Class<T> valType) {
        return this.getValue(target, null, valType);
    }

    public <T> T getValue(Class<?> type, String name, Object obj, Class<T> valType) {
        return this.getValue(this.getField(type, name), obj, valType);
    }

    public <T> T getValue(Class<?> type, String name, Class<T> valType) {
        return this.getValue(type, name, null, valType);
    }

    public boolean setValue(Field target, Object obj, Object value) {
        return this._access.setValue(target, obj, value);
    }

    public boolean setValue(Field target, Object value) {
        return this.setValue(target, null, value);
    }

    public boolean setValue(Field target) {
        return this.setValue(target, null);
    }

    public boolean setValue(Class<?> type, String name, Object obj, Object value) {
        return this.setValue(this.getField(type, name), obj, value);
    }

    public boolean setValue(Class<?> type, String name, Object value) {
        return this.setValue(type, name, null, value);
    }

    public boolean setValue(Class<?> type, String name) {
        return this.setValue(type, name, null);
    }

    public boolean setModifiers(Field target, int mod) {
        return this._access.setModifiers(target, mod);
    }

    public boolean setModifiers(Method target, int mod) {
        return this._access.setModifiers(target, mod);
    }

    public boolean setModifiers(Member target, int mod) {
        if (target instanceof Field) {
            return this.setModifiers((Field)target, mod);
        }
        if (target instanceof Method) {
            return this.setModifiers((Method)target, mod);
        }
        return false;
    }

    public boolean delModifier(Member target, int mod) {
        return this.setModifiers(target, target.getModifiers() & ~mod);
    }

    public boolean setEditable(Member target) {
        int mod = target.getModifiers();
        if (Modifier.isFinal(mod) && Modifier.isStatic(mod)) {
            return this.delModifier(target, 16);
        }
        return true;
    }
}

